/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.LongBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class ARBBindlessTexture {
    public static final int GL_UNSIGNED_INT64_ARB = 5135;

    private ARBBindlessTexture() {
    }

    public static long glGetTextureHandleARB(int texture) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetTextureHandleARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        long __result = ARBBindlessTexture.nglGetTextureHandleARB(texture, function_pointer);
        return __result;
    }

    static native long nglGetTextureHandleARB(int var0, long var1);

    public static long glGetTextureSamplerHandleARB(int texture, int sampler) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetTextureSamplerHandleARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        long __result = ARBBindlessTexture.nglGetTextureSamplerHandleARB(texture, sampler, function_pointer);
        return __result;
    }

    static native long nglGetTextureSamplerHandleARB(int var0, int var1, long var2);

    public static void glMakeTextureHandleResidentARB(long handle) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glMakeTextureHandleResidentARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBBindlessTexture.nglMakeTextureHandleResidentARB(handle, function_pointer);
    }

    static native void nglMakeTextureHandleResidentARB(long var0, long var2);

    public static void glMakeTextureHandleNonResidentARB(long handle) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glMakeTextureHandleNonResidentARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBBindlessTexture.nglMakeTextureHandleNonResidentARB(handle, function_pointer);
    }

    static native void nglMakeTextureHandleNonResidentARB(long var0, long var2);

    public static long glGetImageHandleARB(int texture, int level, boolean layered, int layer, int format2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetImageHandleARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        long __result = ARBBindlessTexture.nglGetImageHandleARB(texture, level, layered, layer, format2, function_pointer);
        return __result;
    }

    static native long nglGetImageHandleARB(int var0, int var1, boolean var2, int var3, int var4, long var5);

    public static void glMakeImageHandleResidentARB(long handle, int access2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glMakeImageHandleResidentARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBBindlessTexture.nglMakeImageHandleResidentARB(handle, access2, function_pointer);
    }

    static native void nglMakeImageHandleResidentARB(long var0, int var2, long var3);

    public static void glMakeImageHandleNonResidentARB(long handle) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glMakeImageHandleNonResidentARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBBindlessTexture.nglMakeImageHandleNonResidentARB(handle, function_pointer);
    }

    static native void nglMakeImageHandleNonResidentARB(long var0, long var2);

    public static void glUniformHandleui64ARB(int location, long value2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glUniformHandleui64ARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBBindlessTexture.nglUniformHandleui64ARB(location, value2, function_pointer);
    }

    static native void nglUniformHandleui64ARB(int var0, long var1, long var3);

    public static void glUniformHandleuARB(int location, LongBuffer value2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glUniformHandleui64vARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(value2);
        ARBBindlessTexture.nglUniformHandleui64vARB(location, value2.remaining(), MemoryUtil.getAddress(value2), function_pointer);
    }

    static native void nglUniformHandleui64vARB(int var0, int var1, long var2, long var4);

    public static void glProgramUniformHandleui64ARB(int program, int location, long value2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glProgramUniformHandleui64ARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBBindlessTexture.nglProgramUniformHandleui64ARB(program, location, value2, function_pointer);
    }

    static native void nglProgramUniformHandleui64ARB(int var0, int var1, long var2, long var4);

    public static void glProgramUniformHandleuARB(int program, int location, LongBuffer values2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glProgramUniformHandleui64vARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(values2);
        ARBBindlessTexture.nglProgramUniformHandleui64vARB(program, location, values2.remaining(), MemoryUtil.getAddress(values2), function_pointer);
    }

    static native void nglProgramUniformHandleui64vARB(int var0, int var1, int var2, long var3, long var5);

    public static boolean glIsTextureHandleResidentARB(long handle) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glIsTextureHandleResidentARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        boolean __result = ARBBindlessTexture.nglIsTextureHandleResidentARB(handle, function_pointer);
        return __result;
    }

    static native boolean nglIsTextureHandleResidentARB(long var0, long var2);

    public static boolean glIsImageHandleResidentARB(long handle) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glIsImageHandleResidentARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        boolean __result = ARBBindlessTexture.nglIsImageHandleResidentARB(handle, function_pointer);
        return __result;
    }

    static native boolean nglIsImageHandleResidentARB(long var0, long var2);

    public static void glVertexAttribL1ui64ARB(int index2, long x) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glVertexAttribL1ui64ARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBBindlessTexture.nglVertexAttribL1ui64ARB(index2, x, function_pointer);
    }

    static native void nglVertexAttribL1ui64ARB(int var0, long var1, long var3);

    public static void glVertexAttribL1uARB(int index2, LongBuffer v) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glVertexAttribL1ui64vARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkBuffer(v, 1);
        ARBBindlessTexture.nglVertexAttribL1ui64vARB(index2, MemoryUtil.getAddress(v), function_pointer);
    }

    static native void nglVertexAttribL1ui64vARB(int var0, long var1, long var3);

    public static void glGetVertexAttribLuARB(int index2, int pname, LongBuffer params2) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetVertexAttribLui64vARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkBuffer(params2, 4);
        ARBBindlessTexture.nglGetVertexAttribLui64vARB(index2, pname, MemoryUtil.getAddress(params2), function_pointer);
    }

    static native void nglGetVertexAttribLui64vARB(int var0, int var1, long var2, long var4);
}

